{* Flash Sales Prestashop module
 * Copyright 2014, Prestaddons
 * Author: Prestaddons
 * Website: http://www.prestaddons.fr
 *}

<!-- MODULE Block Flash sales -->
{if $fs_products|count>0}
<div id="flash-sales-block-left" class="block products_block">
	<h4 class="title_block">
    	<a href="{$fs_display_link|escape:'htmlall':'UTF-8'}" title="{l s='Check out all flash sales' mod='flashsales'}">{l s='Flash sales' mod='flashsales'}</a>
    </h4>
    <div class="block_content products-block">
		<ul class="products clearfix">
			{counter start=0 skip=1 name=fs_counter print=false}
			{foreach from=$fs_products item='product' name='myLoop'}
				{if {counter name=fs_counter} <= $fs_block_product_number}
				<li class="product_image">
					<a class="products-block-image" href="{$product.link|escape:'html'}" title="{$product.name|escape:html:'UTF-8'}"><img class="replace-2x img-responsive" src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'medium_default')|escape:'html'}" alt="{$product.name|escape:html:'UTF-8'}" /></a>
				</li>
				<li>
					{if $product.specificPrice.reduction_type == 'percentage' && ($product.specificPrice.from == $product.specificPrice.to OR ($smarty.now|date_format:'%Y-%m-%d %H:%M:%S' <= $product.specificPrice.to && $smarty.now|date_format:'%Y-%m-%d %H:%M:%S' >= $product.specificPrice.from))}
						<span class="reduction"><span>-{$product.specificPrice.reduction*100|floatval}%</span></span>
					{/if}
					<h5><a href="{$product.link|escape:'html'}" title="{$product.name|escape:html:'UTF-8'}">{$product.name|strip_tags|escape:html:'UTF-8'}</a></h5>
					{if !$PS_CATALOG_MODE}
						<span class="price-discount">{if !$priceDisplay}{displayWtPrice p=$product.price_without_reduction}{else}{displayWtPrice p=$priceWithoutReduction_tax_excl}{/if}</span>
						<span class="price">{if !$priceDisplay}{displayWtPrice p=$product.price}{else}{displayWtPrice p=$product.price_tax_exc}{/if}</span>
					{/if}
					<br class="clear"/>
				</li>
				{/if}
			{/foreach}
		</ul>
		<p>
			<a href="{$fs_display_link|escape:'htmlall':'UTF-8'}" title="{l s='Check out all flash sales' mod='flashsales'}">&raquo; {l s='Check out all flash sales' mod='flashsales'}</a>
		</p>
    </div>
</div>
{/if}
<!-- /MODULE Block Flash sales -->