{* Flash Sales Prestashop module
 * Copyright 2014, Prestaddons
 * Author: Prestaddons
 * Website: http://www.prestaddons.fr
 *}

<!-- MODULE Block Flash sales -->
{if $fs_products|count>0}
<div id="flash-sales-block-left" class="block products_block">
	<h4 class="title_block">
    	<a href="{$fs_display_link|escape:'htmlall':'UTF-8'}" title="{l s='Check out all flash sales' mod='flashsales'}">{l s='Flash sales' mod='flashsales'}</a>
    </h4>
    <div class="block_content products-block">
		<ul class="products">
			{counter start=0 skip=1 name=fs_counter print=false}
			{foreach from=$fs_products item='product' name='myLoop'}
				{if {counter name=fs_counter} <= $fs_block_product_number}
				<li class="clearfix">
					<a class="products-block-image" href="{$product.link|escape:'html'}" title="{$product.name|escape:html:'UTF-8'}"><img class="replace-2x img-responsive" src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'small_default')|escape:'html'}" alt="{$product.name|escape:html:'UTF-8'}" /></a>
					<div class="product-content">
						<h5>
							<a class="product-name" href="{$product.link|escape:'html'}" title="{$product.name|escape:html:'UTF-8'}">{$product.name|strip_tags|escape:html:'UTF-8'}</a>
						</h5>
						<p class="product-description">{$product.description_short|strip_tags:'UTF-8'|truncate:75:'...'}</p>
						{if (!$PS_CATALOG_MODE AND ((isset($product.show_price) && $product.show_price) || (isset($product.available_for_order) && $product.available_for_order)))}
							{if isset($product.show_price) && $product.show_price && !isset($restricted_country_mode)}
								<div class="price-box">
									{if !$PS_CATALOG_MODE}
										<span class="price special-price">
											{if !$priceDisplay}
												{displayWtPrice p=$product.price}{else}{displayWtPrice p=$product.price_tax_exc}
											{/if}
										</span>
										 {if $product.specific_prices}
											{assign var='specific_prices' value=$product.specific_prices}
											{if $specific_prices.reduction_type == 'percentage' && ($specific_prices.from == $specific_prices.to OR ($smarty.now|date_format:'%Y-%m-%d %H:%M:%S' <= $specific_prices.to && $smarty.now|date_format:'%Y-%m-%d %H:%M:%S' >= $specific_prices.from))}
												<span class="price-percent-reduction">-{$specific_prices.reduction*100|floatval}%</span>
											{/if}
										{/if}
										 <span class="old-price">
											{if !$priceDisplay}
												{displayWtPrice p=$product.price_without_reduction}{else}{displayWtPrice p=$priceWithoutReduction_tax_excl}
											{/if}
										</span>
									{/if}
								</div>
							{/if}
						{/if}
					</div>
				</li>
				{/if}
			{/foreach}
		</ul>
		<div>
			<a href="{$fs_display_link|escape:'htmlall':'UTF-8'}" title="{l s='Check out all flash sales' mod='flashsales'}" class="btn btn-default button button-small"><span>{l s='Check out all flash sales' mod='flashsales'}<i class="icon-chevron-right right"></i></span></a>
		</div>
    </div>
</div>
{/if}
<!-- /MODULE Block Flash sales -->