{* Flash sales Prestashop module
 * Copyright 2014, Prestaddons
 * Author: Prestaddons
 * Website: http://www.prestaddons.fr
 *}

<script type="text/javascript">
	
	// Needed for WYSIWYG 
	var iso = '{$iso|addslashes}';
	var pathCSS = '{$smarty.const._THEME_CSS_DIR_|addslashes}';
	var ad = '{$ad|addslashes}';

	$(document).ready(function(){
		{block name="autoload_tinyMCE"}
			tinySetup({
				editor_selector :"autoload_rte"
			});
		{/block}
	});
	
	var id_language = Number({$defaultFormLanguage|escape:'UTF-8'});
	var languages = new Array();
	
	{foreach from=$languages key=k item=language}
	languages[{$k|escape:'UTF-8'}] = {
		id_lang: {$language.id_lang|escape:'UTF-8'},
		iso_code: "{$language.iso_code|escape:'UTF-8'}",
		name: "{$language.name|escape:html:'UTF-8'}"
	};
	{/foreach}
</script>

<div class="toolbar-placeholder">
	<div class="toolbarBox">
		<ul class="cc_button">
			<li>
				<a class="toolbar_btn" href="{$back_link|escape:'UTF-8'}" title="{l s='Back to list' mod='flashsales'}">
					<span class="process-icon-back"></span>
					<div class="locked">{l s='Back to list' mod='flashsales'}</div>
				</a>
			</li>
			<li>
				<a class="toolbar_btn" href="{$support_link|escape:'UTF-8'}" title="{l s='Support' mod='flashsales'}">
					<span class="process-icon-help-new"></span>
					<div class="locked">{l s='Support' mod='flashsales'}</div>
				</a>
			</li>
		</ul>
		<div class="pageTitle">
			<h3>
				<span style="font-weight: normal;" id="current_obj">
					<span class="breadcrumb item-0">{$display_name|escape:'UTF-8'}</span>
				</span>
			</h3>
		</div>
	</div>
</div>
<div class="leadin"></div>
<fieldset>
	<legend><img src="{$path|escape:'UTF-8'}img/settings_16x16.png" alt="{l s='Settings' mod='flashsales'} - {l s='Counters' mod='flashsales'}" />{l s='Settings' mod='flashsales'} - {l s='Counters' mod='flashsales'}</legend>

	<form action="" id="" method="post" class="form-horizontal">

		<div class="form-group">
			<label for="font_color">
				{l s='Font color' mod='flashsales'}
			</label>
			<div class="margin-form">
				<div class="input-group fixed-width-xl">
					<input type="color" data-hex="true" id="font_color" name="font_color" class="color mColorPickerInput" value="{$font_color|escape:'html':'UTF-8'}"/>
				</div>
				<p class="help-block">{l s='Set the counter font color' mod='flashsales'}</p>
			</div>
		</div>
		<div class="form-group">
			<label for="bg_color_start">
				{l s='First background color' mod='flashsales'}
			</label>
			<div class="margin-form">
				<div class="input-group fixed-width-xl">
					<input type="color" data-hex="true" id="bg_color_start" name="bg_color_start" class="color mColorPickerInput" value="{$bg_color_start|escape:'html':'UTF-8'}"/>
				</div>
				<p class="help-block">{l s='Set the first counter background color' mod='flashsales'}</p>
			</div>
		</div>
		<div class="form-group">
			<label for="bg_color_end">
				{l s='Second background color' mod='flashsales'}
			</label>
			<div class="margin-form">
				<div class="input-group fixed-width-xl">
					<input type="color" data-hex="true" id="bg_color_end" name="bg_color_end" class="color mColorPickerInput" value="{$bg_color_end|escape:'html':'UTF-8'}"/>
				</div>
				<p class="help-block">{l s='Set the second counter background color' mod='flashsales'}</p>
			</div>
		</div>
		<div class="form-group">
			<label for="product_text">
				{l s='Product text' mod='flashsales'}
			</label>
			<div class="margin-form translatable">
				{foreach $languages item=language}
				<div class="lang_{$language.id_lang}" style="{if $language.id_lang != $defaultFormLanguage}display:none;{/if}float:left;">
					<input type="text" id="product_text_{$language.id_lang}" name="product_text_{$language.id_lang}" class="fixed-width-xl" value="{if isset($product_text[$language.id_lang])}{$product_text[$language.id_lang]}{/if}"/>
				</div>
				{/foreach}
				<script type="text/javascript">
					displayFlags(languages, {$defaultFormLanguage|escape:'UTF-8'}, 1);
				</script>
				<br style="clear:both;"/>
				<p class="help-block">{l s='Set the text above the counter in product sheets' mod='flashsales'}</p>
			</div>
		</div>
		<div class="form-group">
			<label for="product_font_color">
				{l s='Product font color' mod='flashsales'}
			</label>
			<div class="margin-form">
				<div class="input-group fixed-width-xl">
					<input type="color" data-hex="true" id="product_font_color" name="product_font_color" class="color mColorPickerInput" value="{$product_font_color|escape:'html':'UTF-8'}"/>
				</div>
				<p class="help-block">{l s='Set the font color above the counter in product sheets' mod='flashsales'}</p>
			</div>
		</div>
		<div class="form-group">
			<label for="disp_border">{l s='Display border' mod='flashsales'}</label>
			<div class="margin-form">
				<span class="switch prestashop-switch fixed-width-lg">
					<input type="radio" value="1" {if $disp_border}checked="checked"{/if} id="disp_border_on" name="disp_border">
					<img title="{l s='Yes' mod='flashsales'}" alt="{l s='Yes' mod='flashsales'}" src="../img/admin/enabled.gif" />
					<input type="radio" value="0" {if !$disp_border}checked="checked"{/if} id="disp_border_off" name="disp_border">
					<img title="{l s='No' mod='flashsales'}" alt="{l s='No' mod='flashsales'}" src="../img/admin/disabled.gif" />
				</span>
				<p class="help-block">{l s='Display border around the counter in product sheets' mod='flashsales'}</p>
			</div>
		</div>
		<div class="form-group">
			<label for="border_color">
				{l s='Border color' mod='flashsales'}
			</label>
			<div class="margin-form">
				<div class="input-group fixed-width-xl">
					<input type="color" data-hex="true" id="border_color" name="border_color" class="color mColorPickerInput" value="{$border_color|escape:'html':'UTF-8'}"/>
				</div>
				<p class="help-block">{l s='Set the color of the border around the counter in product sheets' mod='flashsales'}</p>
			</div>
		</div>

		<div class="center">
			<input name="submitproductpages" type="submit" value="{l s='Save' mod='flashsales'}" />
		</div>
	</form>
</fieldset>
<br />
<fieldset>
	<legend><img src="{$path|escape:'UTF-8'}img/settings_16x16.png" alt="{l s='Settings' mod='flashsales'} - {l s='Flash sales page' mod='flashsales'}" />{l s='Settings' mod='flashsales'} - {l s='Flash sales page' mod='flashsales'}</legend>

	<form action="" id="" method="post" enctype="multipart/form-data" class="form-horizontal">

		<div class="form-group">
			<label for="meta_title">
				{l s='Meta title' mod='flashsales'}
			</label>
			<div class="margin-form translatable">
				{foreach $languages as $language}
				<div class="lang_{$language.id_lang}" style="{if $language.id_lang != $defaultFormLanguage}display:none;{/if}float:left;">
					<input type="text" id="meta_title_{$language.id_lang}" name="meta_title_{$language.id_lang}" class="fixed-width-xl" value="{if isset($meta_title[$language.id_lang])}{$meta_title[$language.id_lang]}{/if}"/>
				</div>
				{/foreach}
				<script type="text/javascript">
					displayFlags(languages, {$defaultFormLanguage|escape:'UTF-8'}, 1);
				</script>
				<br style="clear:both;"/>
				<p class="help-block">{l s='Set the form meta title' mod='flashsales'}</p>
			</div>
		</div>
		<div class="form-group">
			<label for="meta_description">
				{l s='Meta description' mod='flashsales'}
			</label>
			<div class="margin-form translatable">
				{foreach $languages as $language}
				<div class="lang_{$language.id_lang}" style="{if $language.id_lang != $defaultFormLanguage}display:none;{/if}float:left;">
					<input type="text" id="meta_description_{$language.id_lang}" name="meta_description_{$language.id_lang}" class="fixed-width-xl" value="{if isset($meta_description[$language.id_lang])}{$meta_description[$language.id_lang]}{/if}"/>
				</div>
				{/foreach}
				<script type="text/javascript">
					displayFlags(languages, {$defaultFormLanguage|escape:'UTF-8'}, 1);
				</script>
				<br style="clear:both;"/>
				<p class="help-block">{l s='Set the form meta description' mod='flashsales'}</p>
			</div>
		</div>
		<div class="form-group">
			<label for="banner_title">
				{l s='Banner title' mod='flashsales'}
			</label>
			<div class="margin-form translatable">
				{foreach $languages as $language}
				<div class="lang_{$language.id_lang}" style="{if $language.id_lang != $defaultFormLanguage}display:none;{/if}float:left;">
					<input type="text" id="banner_title_{$language.id_lang}" name="banner_title_{$language.id_lang}" class="fixed-width-xl" value="{if isset($banner_title[$language.id_lang])}{$banner_title[$language.id_lang]}{/if}"/>
				</div>
				{/foreach}
				<script type="text/javascript">
					displayFlags(languages, {$defaultFormLanguage|escape:'UTF-8'}, 1);
				</script>
				<br style="clear:both;"/>
				<p class="help-block">{l s='Set the banner title' mod='flashsales'}</p>
			</div>
		</div>
		<div class="form-group">
			<label for="banner_text">
				{l s='Banner text' mod='flashsales'}
			</label>
			<div class="margin-form translatable">
				{foreach $languages as $language}
				<div class="lang_{$language.id_lang}" style="{if $language.id_lang != $defaultFormLanguage}display:none;{/if}float:left;">
					<div class="col-lg-9">
						<textarea id="banner_text_{$language.id_lang}" name="banner_text_{$language.id_lang}" class="rte autoload_rte" >{if isset($banner_text[$language.id_lang])}{$banner_text[$language.id_lang]}{/if}</textarea>
					</div>
				</div>
				{/foreach}
				<script type="text/javascript">
					displayFlags(languages, {$defaultFormLanguage|escape:'UTF-8'}, 1);
				</script>
				<br style="clear:both;"/>
				<p class="help-block">{l s='Set the banner text' mod='flashsales'}</p>
			</div>
		</div>
		<div class="form-group">
			<label for="banner_title_color">
				{l s='Banner title color' mod='flashsales'}
			</label>
			<div class="margin-form">
				<div class="input-group fixed-width-xl">
					<input type="color" data-hex="true" id="banner_title_color" name="banner_title_color" class="color mColorPickerInput" value="{$banner_title_color|escape:'html':'UTF-8'}"/>
				</div>
				<p class="help-block">{l s='Set the banner title color' mod='flashsales'}</p>
			</div>
		</div>
		<div class="form-group">
			<label for="banner_text_color">
				{l s='Banner text color' mod='flashsales'}
			</label>
			<div class="margin-form">
				<div class="input-group fixed-width-xl">
					<input type="color" data-hex="true" id="banner_text_color" name="banner_text_color" class="color mColorPickerInput" value="{$banner_text_color|escape:'html':'UTF-8'}"/>
				</div>
				<p class="help-block">{l s='Set the banner text color' mod='flashsales'}</p>
			</div>
		</div>
		<div class="image item-field form-group">
			<label>{l s='Banner image' mod='flashsales'}</label>
			<div class="margin-form">
				<div class="input-group fixed-width-xl">
					<input id="upload-field" type="file" name="banner_img" class="hide" />
				</div>
				<p class="help-block">{l s='Authorized extensions: gif, jpg, jpeg, jpe, png' mod='flashsales'}</p>
			</div>
		</div>
							
		<div class="center">
			<input name="submitflashsalespage" type="submit" value="{l s='Save' mod='flashsales'}"/>
		</div>
	</form>
</fieldset>
<br />
<fieldset>
	<legend><img src="{$path|escape:'UTF-8'}img/settings_16x16.png" alt="{l s='Settings' mod='flashsales'} - {l s='Flash sales block' mod='flashsales'}" />{l s='Settings' mod='flashsales'} - {l s='Flash sales block' mod='flashsales'}</legend>

	<form action="" id="" method="post" class="form-horizontal">

		<div class="form-group">
			<label for="block_product_number">
				{l s='Block product Number' mod='flashsales'}
			</label>
			<div class="margin-form">
				<div class="input-group fixed-width-xl">
					<input type="text" id="block_product_number" name="block_product_number" class="fixed-width-lg" value="{$block_product_number|escape:'html':'UTF-8'}"/>
				</div>
				<p class="help-block">{l s='Set the block product number' mod='flashsales'}</p>
			</div>
		</div>

		<div class="center">
			<input name="submitflashsalesblock" type="submit" value="{l s='Save' mod='flashsales'}"/>
		</div>
	</form>
</fieldset>