{* Flash sales Prestashop module
 * Copyright 2014, Prestaddons
 * Author: Prestaddons
 * Website: http://www.prestaddons.fr
 *}
 
<div class="panel">
	<form action="" id="" method="post" class="form-horizontal">
		<h3>
			<i class="icon-cogs"></i> {l s='Settings' mod='flashsales'} - {l s='Counters' mod='flashsales'}
			<span class="panel-heading-action">
				<a id="desc-module-help-new" class="list-toolbar-btn" href="{$support_link|escape:'UTF-8'}">
					<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Support' mod='flashsales'}" data-html="true">
						<i class="process-icon-help-new"></i>
					</span>
				</a>
			</span>
		</h3>
		<div class="form-wrapper">
			<div class="form-group">
				<label class="control-label col-lg-3" for="font_color">
					{l s='Font color' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
						<div class="col-lg-2">
							<div class="row">
								<div class="input-group fixed-width-xl">
									<input type="color" data-hex="true" id="font_color" name="font_color" class="color mColorPickerInput" value="{$font_color|escape:'html':'UTF-8'}"/>
								</div>
							</div>
						</div>
					</div>
					<p class="help-block">{l s='Set the counter font color' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="bg_color_start">
					{l s='First background color' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
						<div class="col-lg-2">
							<div class="row">
								<div class="input-group fixed-width-xl">
									<input type="color" data-hex="true" id="bg_color_start" name="bg_color_start" class="color mColorPickerInput" value="{$bg_color_start|escape:'html':'UTF-8'}"/>
								</div>
							</div>
						</div>
					</div>
					<p class="help-block">{l s='Set the first counter background color' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="bg_color_end">
					{l s='Second background color' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
						<div class="col-lg-2">
							<div class="row">
								<div class="input-group fixed-width-xl">
									<input type="color" data-hex="true" id="bg_color_end" name="bg_color_end" class="color mColorPickerInput" value="{$bg_color_end|escape:'html':'UTF-8'}"/>
								</div>
							</div>
						</div>
					</div>
					<p class="help-block">{l s='Set the second counter background color' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="product_text">
					{l s='Product text' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
					{foreach $languages as $language}
						{assign var='value_text' value=$product_text[$language.id_lang]}
						<div class="translatable-field lang-{$language.id_lang}" {if $language.id_lang != $defaultFormLanguage}style="display:none"{/if}>
							<div class="col-lg-3">
								<div class="input-group fixed-width-xl">
									<input type="text" id="product_text_{$language.id_lang}" name="product_text_{$language.id_lang}" onkeyup="if (isArrowKey(event)) return ;updateFriendlyURL();" class="fixed-width-xl" value="{$value_text|escape:'html':'UTF-8'}"/>
								</div>
							</div>
							<div class="col-lg-2">
								<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
									{$language.iso_code|escape:'UTF-8'}
									<i class="icon-caret-down"></i>
								</button>
								<ul class="dropdown-menu">
									{foreach from=$languages item=language}
									<li><a href="javascript:hideOtherLanguage({$language.id_lang|escape:'UTF-8'});" tabindex="-1">{$language.name|escape:'UTF-8'}</a></li>
									{/foreach}
								</ul>
							</div>
						</div>
					{/foreach}
					</div>
					<p class="help-block">{l s='Set the text above the counter in product sheets' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="product_font_color">
					{l s='Product font color' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
						<div class="col-lg-2">
							<div class="row">
								<div class="input-group fixed-width-xl">
									<input type="color" data-hex="true" id="product_font_color" name="product_font_color" class="color mColorPickerInput" value="{$product_font_color|escape:'html':'UTF-8'}"/>
								</div>
							</div>
						</div>
					</div>
					<p class="help-block">{l s='Set the font color above the counter in product sheets' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="disp_border">{l s='Display border' mod='flashsales'}</label>
				<div class="col-lg-9">
					<span class="switch prestashop-switch fixed-width-lg">
						<input type="radio" value="1" {if $disp_border}checked="checked"{/if} id="disp_border_on" name="disp_border">
						<label for="disp_border_on">{l s='Yes' mod='flashsales'}</label>
						<input type="radio" value="0" {if !$disp_border}checked="checked"{/if} id="disp_border_off" name="disp_border">
						<label for="disp_border_off">{l s='No' mod='flashsales'}</label>
						<a class="slide-button btn"></a>
					</span>
					<p class="help-block">{l s='Display border around the counter in product sheets' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="border_color">
					{l s='Border color' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
						<div class="col-lg-2">
							<div class="row">
								<div class="input-group fixed-width-xl">
									<input type="color" data-hex="true" id="border_color" name="border_color" class="color mColorPickerInput" value="{$border_color|escape:'html':'UTF-8'}"/>
								</div>
							</div>
						</div>
					</div>
					<p class="help-block">{l s='Set the color of the border around the counter in product sheets' mod='flashsales'}</p>
				</div>
			</div>
		</div>

		<div class="panel-footer">
			<a class="btn btn-default" href="{$back_link|escape:'UTF-8'}"><i class="process-icon-back"></i>{l s='Back to list' mod='flashsales'}</a>
			<button class="btn btn-default pull-right" name="submitproductpages" type="submit"><i class="process-icon-save"></i>{l s='Save' mod='flashsales'}</button>
		</div>
	</form>
</div>
<div class="panel">
	<form action="" id="" method="post" enctype="multipart/form-data" class="form-horizontal">
		<h3><i class="icon-cogs">&nbsp;</i>{l s='Settings' mod='flashsales'} - {l s='Flash sales page' mod='flashsales'}</h3>

		<div class="form-wrapper">
			<div class="form-group">
				<label class="control-label col-lg-3" for="meta_title">
					{l s='Meta title' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
					{foreach $languages as $language}
						{assign var='value_text' value=$meta_title[$language.id_lang]}
						<div class="translatable-field lang-{$language.id_lang}" {if $language.id_lang != $defaultFormLanguage}style="display:none"{/if}>
							<div class="col-lg-3">
								<div class="input-group fixed-width-xl">
									<input type="text" id="meta_title_{$language.id_lang}" name="meta_title_{$language.id_lang}" onkeyup="if (isArrowKey(event)) return ;updateFriendlyURL();" class="fixed-width-xl" value="{$value_text|escape:'html':'UTF-8'}"/>
								</div>
							</div>
							<div class="col-lg-2">
								<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
									{$language.iso_code|escape:'UTF-8'}
									<i class="icon-caret-down"></i>
								</button>
								<ul class="dropdown-menu">
									{foreach from=$languages item=language}
									<li><a href="javascript:hideOtherLanguage({$language.id_lang|escape:'UTF-8'});" tabindex="-1">{$language.name|escape:'UTF-8'}</a></li>
									{/foreach}
								</ul>
							</div>
						</div>
					{/foreach}
					</div>
					<p class="help-block">{l s='Set the form meta title' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="meta_description">
					{l s='Meta description' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
					{foreach $languages as $language}
						{assign var='value_text' value=$meta_description[$language.id_lang]}
						<div class="translatable-field lang-{$language.id_lang|escape:'UTF-8'}" {if $language.id_lang != $defaultFormLanguage}style="display:none"{/if}>
							<div class="col-lg-3">
								<div class="input-group fixed-width-xl">
									<input type="text" id="meta_description_{$language.id_lang|escape:'UTF-8'}" name="meta_description_{$language.id_lang|escape:'UTF-8'}" onkeyup="if (isArrowKey(event)) return ;updateFriendlyURL();" class="fixed-width-xl" value="{$value_text|escape:'html':'UTF-8'}"/>
								</div>
							</div>
							<div class="col-lg-2">
								<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
									{$language.iso_code|escape:'UTF-8'}
									<i class="icon-caret-down"></i>
								</button>
								<ul class="dropdown-menu">
									{foreach from=$languages item=language}
									<li><a href="javascript:hideOtherLanguage({$language.id_lang|escape:'UTF-8'});" tabindex="-1">{$language.name|escape:'UTF-8'}</a></li>
									{/foreach}
								</ul>
							</div>
						</div>
					{/foreach}
					</div>
					<p class="help-block">{l s='Set the form meta description' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="banner_title">
					{l s='Banner title' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
					{foreach $languages as $language}
						{assign var='value_text' value=$banner_title[$language.id_lang]}
						<div class="translatable-field lang-{$language.id_lang}" {if $language.id_lang != $defaultFormLanguage}style="display:none"{/if}>
							<div class="col-lg-3">
								<div class="input-group fixed-width-xl">
									<input type="text" id="banner_title_{$language.id_lang}" name="banner_title_{$language.id_lang}" onkeyup="if (isArrowKey(event)) return ;updateFriendlyURL();" class="fixed-width-xl" value="{$value_text|escape:'html':'UTF-8'}"/>
								</div>
							</div>
							<div class="col-lg-2">
								<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
									{$language.iso_code|escape:'UTF-8'}
									<i class="icon-caret-down"></i>
								</button>
								<ul class="dropdown-menu">
									{foreach from=$languages item=language}
									<li><a href="javascript:hideOtherLanguage({$language.id_lang|escape:'UTF-8'});" tabindex="-1">{$language.name|escape:'UTF-8'}</a></li>
									{/foreach}
								</ul>
							</div>
						</div>
					{/foreach}
					</div>
					<p class="help-block">{l s='Set the banner title' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="banner_text">
					{l s='Banner text' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
					{foreach $languages as $language}
						{assign var='value_textarea' value=$banner_text[$language.id_lang]}
						<div class="form-group translatable-field lang-{$language.id_lang}" {if $language.id_lang != $defaultFormLanguage}style="display:none;"{/if}>
							<div class="col-lg-9">
								<textarea id="banner_text_{$language.id_lang}" name="banner_text_{$language.id_lang}" class="rte autoload_rte" >{$value_textarea|escape:'UTF-8'}</textarea>
								<p class="help-block">{l s='Set the banner text' mod='flashsales'}</p>
							</div>
							<div class="col-lg-2">
								<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
									{$language.iso_code|escape:'UTF-8'}
									<i class="icon-caret-down"></i>
								</button>
								<ul class="dropdown-menu">
									{foreach from=$languages item=language}
									<li><a href="javascript:hideOtherLanguage({$language.id_lang|escape:'UTF-8'});" tabindex="-1">{$language.name|escape:'UTF-8'}</a></li>
									{/foreach}
								</ul>
							</div>
						</div>
					{/foreach}
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="banner_title_color">
					{l s='Banner title color' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
						<div class="col-lg-2">
							<div class="row">
								<div class="input-group fixed-width-xl">
									<input type="color" data-hex="true" id="banner_title_color" name="banner_title_color" class="color mColorPickerInput" value="{$banner_title_color|escape:'html':'UTF-8'}"/>
								</div>
							</div>
						</div>
					</div>
					<p class="help-block">{l s='Set the banner title color' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="banner_text_color">
					{l s='Banner text color' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
						<div class="col-lg-2">
							<div class="row">
								<div class="input-group fixed-width-xl">
									<input type="color" data-hex="true" id="banner_text_color" name="banner_text_color" class="color mColorPickerInput" value="{$banner_text_color|escape:'html':'UTF-8'}"/>
								</div>
							</div>
						</div>
					</div>
					<p class="help-block">{l s='Set the banner text color' mod='flashsales'}</p>
				</div>
			</div>
			<div class="image item-field form-group">
				<label class="control-label col-lg-3">{l s='Banner image' mod='flashsales'}</label>
				<div class="col-lg-3">
					<input id="upload-field" type="file" name="banner_img" class="hide" />
					<div class="input-group">
						<span class="input-group-addon"><i class="icon-file"></i></span>
						<input id="filename" type="text" name="filename" readonly />
						<span class="input-group-btn">
							<button id="selectbutton" type="button" name="submitBannerImg" class="btn btn-default">
								<i class="icon-folder-open"></i> {l s='Add file' mod='flashsales'}
							</button>
						</span>
					</div>
					<p class="help-block">{l s='Authorized extensions: gif, jpg, jpeg, jpe, png' mod='flashsales'}</p>
				</div>
			</div>
		</div>
							
		<div class="panel-footer">
			<a class="btn btn-default" href="{$back_link|escape:'UTF-8'}"><i class="process-icon-back"></i>{l s='Back to list' mod='flashsales'}</a>
			<button class="btn btn-default pull-right" name="submitflashsalespage" type="submit"><i class="process-icon-save"></i>{l s='Save' mod='flashsales'}</button>
		</div>
	</form>
</div>
<div class="panel">
	<form action="" id="" method="post" class="form-horizontal">
		<h3><i class="icon-cogs">&nbsp;</i>{l s='Settings' mod='flashsales'} - {l s='Flash sales block' mod='flashsales'}</h3>

		<div class="form-wrapper">
			<div class="form-group">
				<label class="control-label col-lg-3" for="block_product_number">
					{l s='Block product Number' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="form-group">
						<div class="col-lg-2">
							<div class="row">
								<div class="input-group fixed-width-xl">
									<input type="text" id="block_product_number" name="block_product_number" class="fixed-width-lg" value="{$block_product_number|escape:'html':'UTF-8'}"/>
								</div>
							</div>
						</div>
					</div>
					<p class="help-block">{l s='Set the block product number' mod='flashsales'}</p>
				</div>
			</div>
		</div>

		<div class="panel-footer">
			<a class="btn btn-default" href="{$back_link|escape:'UTF-8'}"><i class="process-icon-back"></i>{l s='Back to list' mod='flashsales'}</a>
			<button class="btn btn-default pull-right" name="submitflashsalesblock" type="submit"><i class="process-icon-save"></i>{l s='Save' mod='flashsales'}</button>
		</div>
	</form>
</div>
<script type="text/javascript">
	
	// Needed for WYSIWYG 
	var iso = '{$iso|addslashes}';
	var pathCSS = '{$smarty.const._THEME_CSS_DIR_|addslashes}';
	var ad = '{$ad|addslashes}';

	$(document).ready(function(){
		{block name="autoload_tinyMCE"}
			tinySetup({
				editor_selector :"autoload_rte"
			});
		{/block}
	});
	
	// Needed for Custom Upload field
	$(document).ready(function(){
		$('#selectbutton').click(function(e) {
			$('#upload-field').trigger('click');
		});

		$('#filename').click(function(e) {
			$('#upload-field').trigger('click');
		});

		$('#filename').on('dragenter', function(e) {
			e.stopPropagation();
			e.preventDefault();
		});

		$('#filename').on('dragover', function(e) {
			e.stopPropagation();
			e.preventDefault();
		});

		$('#filename').on('drop', function(e) {
			e.preventDefault();
			var files = e.originalEvent.dataTransfer.files;
			$('#upload-field')[0].files = files;
			$(this).val(files[0].name);
		});
		
		$('#upload-field').change(function(e) {
			if ($(this)[0].files !== undefined)
			{
				var files = $(this)[0].files;
				var name  = '';

				$.each(files, function(index, value) {
					name += value.name+', ';
				});

				$('#filename').val(name.slice(0, -2));
			}
			else // Internet Explorer 9 Compatibility
			{
				var name = $(this).val().split(/[\\/]/);
				$('#filename').val(name[name.length-1]);
			}
		});
	});
</script>