{* Flash sales Prestashop module
 * Copyright 2014, Prestaddons
 * Author: Prestaddons
 * Website: http://www.prestaddons.fr
 *}

<script type="text/javascript">
	var path = '{$path|escape:'UTF-8'}';
	var combination_text = '{l s='Apply to all combinations' mod='flashsales'}';
	{if $psversion16}
		var psversion16 = true;
	{else}
		var psversion16 = false;
	{/if}
</script>
<form action="" id="{$table|escape:'UTF-8'}_form" method="post" class="form-horizontal">
	<input type="hidden" name="action_form" value="{$action_form|escape:'UTF-8'}" />
	<input type="hidden" name="id_flash_sale" value="{$id_flash_sale|escape:'UTF-8'}" />
	<input type="hidden" name="id_specific_price" value="{$id_specific_price|escape:'UTF-8'}" />
	<div class="panel">
		<h3>
			<i class="icon-flash"></i>
			{if $action_form == 'add'}{l s='Add a flash sale' mod='flashsales'}{else}{l s='Update a flash sale' mod='flashsales'}{/if}
			<span class="panel-heading-action">
				<a id="desc-module-help-new" class="list-toolbar-btn" href="{$support_link|escape:'UTF-8'}">
					<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Support' mod='flashsales'}" data-html="true">
						<i class="process-icon-help-new"></i>
					</span>
				</a>
			</span>
		</h3>
		<div class="form-wrapper">
			<div class="form-group">
				<label class="control-label col-lg-3" for="product_autocomplete_input">
					<span class="label-tooltip" data-toggle="tooltip" title="{l s='Start by typing the first letters of the product\'s name, then select the product from the drop-down list.' mod='flashsales'}">
					{l s='Product' mod='flashsales'}
					</span>
				</label>
				<div class="col-lg-9">
					<input type="hidden" name="id_product" id="id_product" value="{if isset($flash_sale.id_product)}{$flash_sale.id_product|escape:'UTF-8'}{/if}" />
					<input type="hidden" name="product_name" id="product_name" value="{if isset($flash_sale.name)}{$flash_sale.name|escape:'UTF-8'}{/if}" />
					<div id="ajax_choose_product">
						<div class="input-group fixed-width-xl">
							<input type="text" id="product_autocomplete_input" name="product_autocomplete_input" class="fixed-width-xl" />
							<span class="input-group-addon"><i class="icon-search"></i></span>
						</div>
						<p class="help-block">{l s='Set the flash sale product' mod='flashsales'}</p>
					</div>

					<div id="divAccessories">
					{if isset($flash_sale.id_product)}
						<div class="form-control-static">
							<button type="button" class="btn btn-default delAccessory" name="{$flash_sale.name|escape:'UTF-8'}">
								<i class="icon-remove text-danger"></i>
							</button>
							{$flash_sale.name|escape:'html':'UTF-8'}
						</div>
					{/if}
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="id_product_attribute">{l s='Combination:' mod='flashsales'}</label>
				<div class="col-lg-9">
					<select id="id_product_attribute" name="id_product_attribute" class="fixed-width-xxl">
						<option value="0" {if isset($flash_sale.id_product_attribute) && $flash_sale.id_product_attribute == 0}selected="selected"{/if}>{l s='Apply to all combinations' mod='flashsales'}</option>
						{foreach from=$combinations item='combination'}
							<option value="{$combination.id_product_attribute}" {if $flash_sale.id_product_attribute == $combination.id_product_attribute}selected="selected"{/if}>{$combination.attributes}</option>
						{/foreach}
					</select>
					<p class="help-block">{l s='Set the flash sale to a specific combination' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="id_currency">
					{l s='For' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="input-group fixed-width-xl">
						<select name="id_currency" id="id_currency">
							<option value="0">{l s='All currencies' mod='flashsales'}</option>
							{foreach from=$currencies item=currency}
								<option value="{$currency.id_currency}" {if isset($flash_sale.id_currency) && $flash_sale.id_currency == $currency.id_currency}selected="selected"{/if}>{$currency.name}</option>
							{/foreach}
						</select>
					</div>
					<p class="help-block">{l s='Flash sale will be only available for this currency' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="id_country">
					{l s='For' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="input-group fixed-width-xl">
						<select name="id_country" id="id_country">
							<option value="0">{l s='All countries' mod='flashsales'}</option>
							{foreach from=$countries item=country}
								<option value="{$country.id_country}" {if isset($flash_sale.id_country) && $flash_sale.id_country == $country.id_country}selected="selected"{/if}>{$country.name}</option>
							{/foreach}
						</select>
					</div>
					<p class="help-block">{l s='Flash sale will be only available for this country' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="id_group">
					{l s='For' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="input-group fixed-width-xl">
						<select name="id_group" id="id_group">
							<option value="0">{l s='All groups' mod='flashsales'}</option>
							{foreach from=$groups item=group}
								<option value="{$group.id_group}" {if isset($flash_sale.id_group) && $flash_sale.id_group == $group.id_group}selected="selected"{/if}>{$group.name}</option>
							{/foreach}
						</select>
					</div>
					<p class="help-block">{l s='Flash sale will be only available for this group' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="date_from">
					{l s='From' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="input-group fixed-width-xl">
						<input type="text" id="date_from" name="date_from" class="fixed-width-xl datepicker" value="{if isset($flash_sale.date_from)}{$flash_sale.date_from|escape:'UTF-8'}{/if}"/>
						<span class="input-group-addon"><i class="icon-calendar"></i></span>
					</div>
					<p class="help-block">{l s='Start date of the flash sale' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="date_to">
					{l s='To' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="input-group fixed-width-xl">
						<input type="text" id="date_to" name="date_to" class="fixed-width-xl datepicker" value="{if isset($flash_sale.date_to)}{$flash_sale.date_to|escape:'UTF-8'}{/if}"/>
						<span class="input-group-addon"><i class="icon-calendar"></i></span>
					</div>
					<p class="help-block">{l s='End date of the flash sale' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="discount">
					{l s='Discount' mod='flashsales'}
				</label>
				<div class="col-lg-9">
					<div class="input-group">
						<input type="text" id="discount" name="discount" class="fixed-width-sm" value="{if isset($flash_sale.discount)}{$flash_sale.discount|string_format:"%.2f"|escape:'UTF-8'}{/if}" style="float:left;margin-right:5px;"/>
						<select id="unit_discount" name="unit_discount" class="fixed-width-lg">
							<option {if !isset($flash_sale.unit_discount)}selected="selected"{/if}>-</option>
							<option value="amount" {if isset($flash_sale.unit_discount) && $flash_sale.unit_discount == 'amount'}selected="selected"{/if}>{l s='Currency Units' mod='flashsales'}</option>
							<option value="percentage" {if isset($flash_sale.unit_discount) && $flash_sale.unit_discount == 'percentage'}selected="selected"{/if}>{l s='Percent' mod='flashsales'}</option>
						</select>
					</div>
					<p class="help-block">{l s='Set the flash sale discount' mod='flashsales'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="status">{l s='Active' mod='flashsales'}</label>
				<div class="col-lg-9 ">
					<span class="switch prestashop-switch fixed-width-lg">
						<input type="radio" value="1" {if isset($flash_sale.status) && $flash_sale.status}checked="checked"{else}checked="checked"{/if} id="status_on" name="status">
						<label for="status_on">{l s='Yes' mod='flashsales'}</label>
						<input type="radio" value="0" {if isset($flash_sale.status) && !$flash_sale.status}checked="checked"{/if} id="status_off" name="status">
						<label for="status_off">{l s='No' mod='flashsales'}</label>
						<a class="slide-button btn"></a>
					</span>
					<p class="help-block">{l s='Actives the flash sale' mod='flashsales'}</p>
				</div>
			</div>
		</div>
				
		<div class="panel-footer">
			<a class="btn btn-default" href="{$back_link|escape:'UTF-8'}"><i class="process-icon-back"></i>{l s='Back to list' mod='flashsales'}</a>
			<button class="btn btn-default pull-right" name="submitflashsales" type="submit"><i class="process-icon-save"></i>{l s='Save' mod='flashsales'}</button>
		</div>
	</div>
</form>