/* Flash Sales Prestashop module
 * Copyright 2014, Prestaddons
 * Author: Prestaddons
 * Website: http://www.prestaddons.fr
 */

$(document).ready(function() {
	
	var date = new Date();
	var hours = date.getHours();
	if (hours < 10)
		hours = "0" + hours;
	var mins = date.getMinutes();
	if (mins < 10)
		mins = "0" + mins;
	var secs = date.getSeconds();
	if (secs < 10)
		secs = "0" + secs;
	$('.datepicker').datepicker({
		prevText: '',
		nextText: '',
		dateFormat: 'yy-mm-dd ' + hours + ':' + mins + ':' + secs
	});
	
	// Autocomplétion du champ input d'ajout de produit
	var initAccessoriesAutocomplete = function (){
        $('#product_autocomplete_input')
			.autocomplete(path+'ajax_products_list.php', {
				minChars: 1,
				autoFill: true,
				max:20,
				matchContains: true,
				mustMatch:true,
				scroll:false,
				cacheLength:0,
				formatItem: function(item) {
					return item[1]+' - '+item[0];
				}
			}).result(addAccessory);

		$('#product_autocomplete_input').setOptions({
			extraParams: {
				excludeIds : getAccessoriesIds()
			}
		});
	};
	
	var getAccessoriesIds = function()
	{
		if ($('#id_product').val() === undefined)
			return '';
		return $('#id_product').val().replace(/\-/g,',');
	}

	var addAccessory = function(event, data, formatted)
	{
		if (data == null)
			return false;
		var productId = data[1];
		var productName = data[0];

		var $divAccessories = $('#divAccessories');
		var $id_product = $('#id_product');
		var $product_name = $('#product_name');

		/* delete product from select + add product line to the div, input_name, input_ids elements */
		if (psversion16)
			$divAccessories.html('<div class="form-control-static"><button type="button" class="delAccessory btn btn-default" name="' + productId + '"><i class="icon-remove text-danger"></i></button>&nbsp;'+ productName +'</div>');
		else
			$divAccessories.html($divAccessories.html() + productName + ' <span class="delAccessory" name="' + productId + '" style="cursor: pointer;"><img src="../img/admin/delete.gif" /></span><br />');
		$product_name.val(productName);
		$id_product.val(productId);
		$('#product_autocomplete_input').val('');
		$('#product_autocomplete_input').setOptions({
			extraParams: {excludeIds : getAccessoriesIds()}
		});
		
		$.post(path+'ajax_combinations_list.php', 
			{id_product: productId}, 
			function(data){
				$('#id_product_attribute').html('<option value="0" selected="selected">'+combination_text+'</option>'+data);
			}
		);
	};

	var delAccessory = function(id)
	{
		var div = getE('divAccessories');
		var input = getE('id_product');
		var name = getE('product_name');

		// Cut hidden fields in array
		var inputCut = input.value.split('-');
		var nameCut = name.value.split('¤');

		if (inputCut.length != nameCut.length)
			return jAlert('Bad size');

		// Reset all hidden fields
		input.value = '';
		name.value = '';
		div.innerHTML = '';
		for (i in inputCut)
		{
			// If empty, error, next
			if (!inputCut[i] || !nameCut[i])
				continue ;

			// Add to hidden fields no selected products OR add to select field selected product
			if (inputCut[i] != id)
			{
				input.value += inputCut[i] + '-';
				name.value += nameCut[i] + '¤';
				div.innerHTML += '<div class="form-control-static"><button type="button" class="delAccessory btn btn-default" name="' + inputCut[i] +'"><i class="icon-remove text-danger"></i></button>&nbsp;' + nameCut[i] + '</div>';
			}
			else
				$('#selectAccessories').append('<option selected="selected" value="' + inputCut[i] + '-' + nameCut[i] + '">' + inputCut[i] + ' - ' + nameCut[i] + '</option>');
		}

		$('#product_autocomplete_input').setOptions({
			extraParams: {excludeIds : getAccessoriesIds()}
		});
		
		$('#id_product_attribute').html('<option value="0" selected="selected">'+combination_text+'</option>');
	};
	initAccessoriesAutocomplete();
	$('#divAccessories').delegate('.delAccessory', 'click', function(){
		delAccessory($(this).attr('name'));
	});
});

