<?php
/**
 * Flash Sales Prestashop module
 * 
 * @author    Prestaddons <contact@prestaddons.fr>
 * @copyright 2014 Prestaddons
 * @license
 * @link      http://www.prestaddons.fr
 */

class FsModel
{
	private static $table_name = 'fs_product';

	/**
	 * Méthode createDB()
	 * 
	 * Créé les tables MySQL nécessaires au module.
	 */
	public static function createDB()
	{
		$result = Db::getInstance()->execute('
			CREATE TABLE '._DB_PREFIX_.self::$table_name.' (
			`id_flash_sale` int(10) NOT NULL AUTO_INCREMENT, 
			`id_product` int(10) NOT NULL,
			`id_product_attribute` int(10) NOT NULL,
			`date_from` datetime NOT NULL,
			`date_to` datetime NOT NULL,
			`discount` decimal(20,6) NOT NULL,
			`unit_discount` enum(\'amount\', \'percentage\') NOT NULL,
			`status` tinyint(1) NOT NULL,
			`id_specific_price` int(10) NOT NULL,
			`id_shop` int(11) NOT NULL,
			`id_currency` int(10) NOT NULL,
			`id_country` int(10) NOT NULL,
			`id_group` int(10) NOT NULL,
			PRIMARY KEY(`id_flash_sale`))
			ENGINE='._MYSQL_ENGINE_.' default CHARSET=utf8');

		return $result;
	}

	/**
	 * Méthode dropDB()
	 * 
	 * Supprime les tables MySQL utilisées par le module.
	 */
	public static function dropDB()
	{
		return Db::getInstance()->execute('DROP TABLE '._DB_PREFIX_.self::$table_name);
	}

	public static function getFlashSales($order_by = '', $order_way = '')
	{
		$sql = 'SELECT *
				FROM `'._DB_PREFIX_.self::$table_name.'` 
				WHERE id_shop = '.(int)Context::getContext()->shop->id;

		if ($order_by != '')
			$sql .= ' ORDER BY '.$order_by.' '.$order_way.' ';

		return Db::getInstance()->executeS($sql);
	}

	public static function getFlashSale($id_flash_sale)
	{
		$sql = 'SELECT * FROM `'._DB_PREFIX_.self::$table_name.'`
				WHERE `id_flash_sale` = '.(int)$id_flash_sale.'
				AND id_shop = '.(int)Context::getContext()->shop->id;

		return Db::getInstance()->executeS($sql);
	}

	public static function getFlashSaleByIdProduct($id_product)
	{
		$sql = 'SELECT * FROM `'._DB_PREFIX_.self::$table_name.'`
				WHERE `id_product` = '.(int)$id_product.'
				AND id_shop = '.(int)Context::getContext()->shop->id;

		return Db::getInstance()->executeS($sql);
	}

	public static function insertFlashSale($id_product, $id_product_attribute, $date_from, $date_to, $discount, $unit_discount, $status, $id_specific_price, $id_currency, $id_country, $id_group)
	{
		$sql = 'INSERT INTO `'._DB_PREFIX_.self::$table_name.'`
				VALUES ("", '.(int)$id_product.', '.(int)$id_product_attribute.', "'.pSQL($date_from).'", "'.pSQL($date_to).'", '.(float)$discount.', "'.pSQL($unit_discount).'", '.(int)$status.', '.(int)$id_specific_price.', '.(int)Context::getContext()->shop->id.', '.(int)$id_currency.', '.(int)$id_country.', '.(int)$id_group.')';

		return Db::getInstance()->execute($sql);
	}

	public static function updateFlashSale($id_flash_sale, $id_product, $id_product_attribute, $date_from, $date_to, $discount, $unit_discount, $status, $id_specific_price, $id_currency, $id_country, $id_group)
	{
		$sql = 'UPDATE `'._DB_PREFIX_.self::$table_name.'`
				SET `id_product` = '.(int)$id_product.', `id_product_attribute` = '.(int)$id_product_attribute.', `date_from` = "'.pSQL($date_from).'", `date_to` = "'.pSQL($date_to).'", `discount` = '.(float)$discount.', `unit_discount` = "'.pSQL($unit_discount).'", `status` = '.(int)$status.', `id_specific_price` = '.(int)$id_specific_price.', `id_currency` = '.(int)$id_currency.', `id_country` = '.(int)$id_country.', `id_group` = '.(int)$id_group.'
				WHERE `id_flash_sale` = '.(int)$id_flash_sale.'
				AND id_shop = '.(int)Context::getContext()->shop->id;

		return Db::getInstance()->execute($sql);
	}

	public static function updateStatus($id_flash_sale, $status, $id_specific_price)
	{
		$sql = 'UPDATE `'._DB_PREFIX_.self::$table_name.'`
				SET `status` = '.$status.', `id_specific_price` = '.(int)$id_specific_price.'
				WHERE `id_flash_sale` = '.(int)$id_flash_sale.'
				AND id_shop = '.(int)Context::getContext()->shop->id;

		return Db::getInstance()->execute($sql);
	}

	public static function deleteFlashSale($id_flash_sale)
	{
		$sql = 'DELETE FROM `'._DB_PREFIX_.self::$table_name.'`
				WHERE `id_flash_sale` = '.(int)$id_flash_sale.'
				AND id_shop = '.(int)Context::getContext()->shop->id;

		return Db::getInstance()->execute($sql);
	}

	public static function getByProductId($id_product, $id_product_attribute = false, $id_cart = false)
	{
		$sql = 'SELECT *
				FROM `'._DB_PREFIX_.'specific_price`
				WHERE `id_product` = '.(int)$id_product.
				($id_product_attribute ? ' AND id_product_attribute = '.(int)$id_product_attribute : '').'
				AND id_cart = '.(int)$id_cart.'
				AND id_shop = '.(int)Context::getContext()->shop->id;

		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
	}
}