<?php
/**
 * Flash Sales Prestashop module
 * 
 * @author    Prestaddons <contact@prestaddons.fr>
 * @copyright 2014 Prestaddons
 * @license
 * @link      http://www.prestaddons.fr
 */

class FlashSalesDisplayModuleFrontController extends ModuleFrontController
{
	public $auth = false;
	public $php_self = '';
	public $ssl = true;

	public function setMedia()
	{
		parent::setMedia();

		$this->addCSS(_THEME_CSS_DIR_.'/category.css');
		if ($this->module->checkPSVersion('1.6.0.0'))
			$this->addCSS(_MODULE_DIR_.$this->module->name.'/css/fs-product-s-'.$this->context->shop->id.'.css');
		else
			$this->addCSS(_MODULE_DIR_.$this->module->name.'/css/fs-product15-s-'.$this->context->shop->id.'.css');

		$this->addJS(_MODULE_DIR_.$this->module->name.'/js/jquery.countdown.js');
		$this->addJS(_MODULE_DIR_.$this->module->name.'/js/flashsales.js');
	}

	/**
	 * Assign template vars related to page content
	 * @see FrontController::initContent()
	 */
	public function initContent()
	{
		parent::initContent();

		$meta_title = unserialize(rawurldecode(Configuration::get($this->module->short_name.'_meta_title')));
		$meta_description = unserialize(rawurldecode(Configuration::get($this->module->short_name.'_meta_description')));
		$banner_title = unserialize(rawurldecode(Configuration::get($this->module->short_name.'_banner_title')));
		$banner_text = unserialize(rawurldecode(Configuration::get($this->module->short_name.'_banner_text')));

		$this->context->smarty->assign(array(
			'server_date' => date('D M d Y H:i:s O'),
			'meta_title' => $meta_title[$this->context->cookie->id_lang],
			'meta_description' => $meta_description[$this->context->cookie->id_lang],
			'banner_title' => $banner_title[$this->context->cookie->id_lang],
			'banner_text' => $banner_text[$this->context->cookie->id_lang],
			'products' => $this->module->getFlashSalesProducts('date_to', 'ASC'),
			'categorySize' => ($this->module->checkPSVersion('1.6.0.0'))?Image::getSize(ImageType::getFormatedName('category')):array(),
			'categoryImg' => Configuration::get($this->module->short_name.'_banner_img'),
			'fs_path' => _MODULE_DIR_.$this->module->name.'/',
			'ps_version1607' => $this->module->checkPSVersion('1.6.0.7')
		));

		if (!$this->module->checkPSVersion('1.6.0.0'))
			$this->setTemplate('display15.tpl');
		else
			$this->setTemplate('display.tpl');
	}
}