<?php
/**
 * Flash Sales Prestashop module
 * 
 * @author    Prestaddons <contact@prestaddons.fr>
 * @copyright 2014 Prestaddons
 * @license
 * @link      http://www.prestaddons.fr
 */

include(dirname(__FILE__).'/../../config/config.inc.php');
include_once(_PS_ROOT_DIR_.'/init.php');

$query = Tools::getValue('id_product', false);
if (!$query || $query == '' || Tools::strlen($query) < 1)
	die();

$combinations = array();
$product = new Product($query, true, (int)Context::getContext()->language->id);
$attributes = $product->getAttributesGroups((int)Context::getContext()->language->id);
foreach ($attributes as $attribute)
{
	$combinations[$attribute['id_product_attribute']]['id_product_attribute'] = $attribute['id_product_attribute'];
	if (!isset($combinations[$attribute['id_product_attribute']]['attributes']))
		$combinations[$attribute['id_product_attribute']]['attributes'] = '';
	$combinations[$attribute['id_product_attribute']]['attributes'] .= $attribute['attribute_name'].' - ';

	$combinations[$attribute['id_product_attribute']]['price'] = Tools::displayPrice(
		Tools::convertPrice(
			Product::getPriceStatic((int)$product->id, false, $attribute['id_product_attribute']),
			Context::getContext()->currency->id
		), Context::getContext()->currency->id
	);
}

foreach ($combinations as &$combination)
	$combination['attributes'] = rtrim($combination['attributes'], ' - ');

foreach ($combinations as $combination)
	echo '<option value="'.$combination['id_product_attribute'].'">'.$combination['attributes'].'</option>';